export type SellerStatus = 'active' | 'inactive';

export type OrderFulfillmentStatus = 'pending' | 'assigned' | 'fulfilled' | 'cancelled';

export interface Seller {
  id?: string;
  name: string;
  market_id?: string;
  phone: string;
  specialty: string;
  notes?: string;
  status: SellerStatus;
  created_by: string; // admin/supervendor user ID
  created_at?: string;
  updated_at?: string;
}

export interface SellerInventory {
  id?: string;
  seller_id: string;
  product_name: string;
  unit: string;
  price: number;
  available: boolean;
  created_at?: string;
  updated_at?: string;
}

export interface SellerOrder {
  id?: string;
  seller_id: string;
  shopping_list_item_id: string;
  price: number;
  status: OrderFulfillmentStatus;
  assigned_at?: string;
  fulfilled_at?: string;
  created_at?: string;
  updated_at?: string;
}

export interface CreateSellerRequest {
  name: string;
  market_id?: string;
  phone: string;
  specialty: string;
  notes?: string;
}

export interface UpdateSellerRequest {
  name?: string;
  phone?: string;
  specialty?: string;
  status?: SellerStatus;
  notes?: string;
}

export interface AddInventoryRequest {
  product_name: string;
  unit: string;
  price: number;
  available: boolean;
}

export interface UpdateInventoryRequest {
  product_name?: string;
  unit?: string;
  price?: number;
  available?: boolean;
}

export interface AssignOrderRequest {
  shopping_list_item_id: string;
  price: number;
}

export interface MarkFulfilledRequest {
  seller_order_id: string;
}

export interface SellerWithInventory extends Seller {
  inventory?: SellerInventory[];
}

export interface SellerWithOrders extends Seller {
  orders?: SellerOrder[];
}

export interface SellerAnalytics {
  total_orders: number;
  fulfilled_orders: number;
  total_revenue: number;
  average_order_value: number;
  inventory_count: number;
}

export interface ApiResponse<T = any> {
  success: boolean;
  data?: T;
  error?: string;
} 